// =============================================================== //
//                                                                 //
//   File      : AP_matrix.hxx                                     //
//   Purpose   :                                                   //
//                                                                 //
//   Institute of Microbiology (Technical University Munich)       //
//   http://www.arb-home.de/                                       //
//                                                                 //
// =============================================================== //

#ifndef AP_MATRIX_HXX
#define AP_MATRIX_HXX

#ifndef ARBTOOLS_H
#include <arbtools.h>
#endif
#ifndef ARB_STRING_H
#include <arb_string.h>
#endif
#ifndef MATRIX_H
#include <matrix.h>
#endif

#define ap_assert(cond) arb_assert(cond)

CONSTEXPR_INLINE long matrix_halfsize(long entries, bool inclusive_diagonal) {
    return inclusive_diagonal ? entries*(entries+1)/2L : (entries-1)*entries/2L;
}

typedef double AP_FLOAT;

class AW_root;
class AW_window;

struct AP_smatrix : public symmetric_matrix<AP_FLOAT> {
    AP_smatrix(size_t Size_) : symmetric_matrix<AP_FLOAT>(Size_) {}
};

class AP_matrix : virtual Noncopyable {
    AP_FLOAT **m;
    long       size;
public:
    AP_matrix(long si);
    ~AP_matrix();

    void     set(int i, int j, AP_FLOAT val) { m[i][j] = val; };
    AP_FLOAT get(int i, int j) { return m[i][j]; };

    long get_size() const { return size; }
};

class AP_userdef_matrix : public AP_matrix { // derived from Noncopyable
    char **x_description;                                                         // optional description, strdupped
    char **y_description;
    char  *awar_prefix;

    void set_desc(char**& which_desc, int idx, const char *desc);

public:
    AP_userdef_matrix(long si, const char *awar_prefix_)
        : AP_matrix(si),
          x_description(NULp),
          y_description(NULp),
          awar_prefix(ARB_strdup(awar_prefix_))
    {}
    ~AP_userdef_matrix();

    void normize();                                                                     // set average non diag element to 1.0 (only for described elements)

    void set_x_description(int idx, const char *desc) { set_desc(x_description, idx, desc); }
    void set_y_description(int idx, const char *desc) { set_desc(y_description, idx, desc); }
    void set_descriptions(int idx, const char *desc) { set_x_description(idx, desc); set_y_description(idx, desc); }

    void create_awars(AW_root *awr);
    void update_from_awars(AW_root *awr);
    void create_input_fields(AW_window *aww);
};

#else
#error AP_matrix.hxx included twice
#endif // AP_MATRIX_HXX
